<?php

namespace IZON\Users\Web\Interceptors;

use \IZON\MVC\Interceptors\Interceptor;
use \IZON\MVC\HttpRequest;
use \IZON\MVC\ModelAndView;

use IZON\Users\Services\SessionService;

/**
 * zpristupni prihlaseneho uzivatele pro view
 */
class LoadLoggedUserInterceptor implements Interceptor {

  /**
   *
   * @var UserService
   */
  protected $userService;

    /**
     *
     * @var SessionService 
     */
    protected $sessionService;
	
    /**
     * pod jakym jemnem se ma zpristupnit ve view
     * @var string
     */
    protected $loggedUserModelName = "loggedUser";
    
    public function __construct(SessionService $sessionService) {
        $this->sessionService = $sessionService;
    }
    
    public function afterCompletion(HttpRequest $request, $exception) {
        
    }

    public function postHandle(HttpRequest $request, ModelAndView $model) {
        if( $this->sessionService->isUserLoggedIn() ) {
            $loggedUser = $this->sessionService->getLoggedUser();
            $model->putParameter($this->loggedUserModelName, $loggedUser);  
        }
        return $model;
    }

    public function preHandle(HttpRequest $request) {
        
    }
    
    function setLoggedUserModelName($loggedUserModelName) {
        $this->loggedUserModelName = $loggedUserModelName;
    }
}
