<?php

namespace IZON\Users\Services;

use IZON\Users\Domain\User;
use IZON\Users\Presentation\Domain\UserInfo;

/**
 * Servis slouzici k udrzovani iformaci o prihlasenem uzivateli a
 * k prihlaseni a odhlaseni uzivatele
 * @deprecated From always
 */
interface SessionService {
    
    /**
     * prihlasi uzivatele nebo vyhodi vyjimu proc to neni mozne
     * @param string $login
     * @param string $password
     */
    public function loginUser($login, $password);
    
    /**
     * odhlasi v soucasnosti prihlaseneho uzivatele
     */
    public function logoutUser();
    
    /**
     * vraci true pokud je do aplikace prihlsen uzivatel
     * @return boolean
     */
    public function isUserLoggedIn();
    
    /**
     * @return UserInfo currently logged user
     * @throws Exception if user isn't logged in
     */
    public function getLoggedUser();
    
    /**
     * nastavi prihlaseneho uzivatele
     * @param User $user
     */
    public function setLoggedUser(User $user);


    /**
     * is old password correct
     * @param string $password
     */
    public function isLoggedPasswordCorrect($password);
    
    /**
     * zmeni heslo prihlasenemu uzivateli
     * @param string $password
     */
    public function changeLogedUserPassword($password);
    
    /**
     * vrati hash hesla
     * @param string $password
     */
    public function getPasswordHash($password);

    /**
     * sends email with instructions form reset of password
     * @param string $email
     */
    public function handleForgottenPasswordEmail($email);

    /**
     * returns user that request password reset was asked for of null in none such exists
     * @param string $email
     * @param string $resetPasswordId
     * @return User
     */
    public function getResetPasswordUser($email, $resetPasswordId);

    /**
     * resets user password
     * @param integer $userId
     * @param string $hash
     * @param string $password new password
     */
    public function resetUserPassword($userId, $hash, $password);

    /**
     * minimalni pozadovana delka hesla
     */
    public function getMinPasswordLength();
    
}
