<?php
namespace IZON\Users\Web\Interceptors;

use IZON\MVC\HttpRequest;
use IZON\MVC\ModelAndView;

use IZON\Users\Dao\UserDao;
use IZON\Users\Dao\UserRoleDao;
use IZON\Users\Dao\RoleDao;

/**
 * Nastavuje informace o prihlasenem uzivateli
 *
 * @author Vítězslav Jahn <jahn@izon.cz>
 */
class WebUserInterceptor {

  /**
   * Pod jakym nazvem je informace o uzivateli dostupna
   */
  const AVAILABLE_AS  = '_loggedUser';
  /**
   *
   * @var UserDao
   */
  protected $userDao;
  /**
   *
   * @var UserRoleDao
   */
  protected $userRoleDao;
  /**
   *
   * @var RoleDao
   */
  protected $roleDao;
  
  /**
   *
   * @var \IZON\Users\Web\Services\WebUserService
   */
  protected $userService;
  

  public function __construct(\IZON\Users\Web\Services\WebUserService $userService,
                              UserDao $userDao, 
                              UserRoleDao $userRoleDao,
                              RoleDao $roleDao
                              ) {
    $this->userDao      = $userDao;
    $this->userRoleDao  = $userRoleDao;
    $this->roleDao      = $roleDao;
    $this->userService = $userService;
  }
  
  public function afterCompletion(HttpRequest $request, $exception) {
      
  }

  public function postHandle(HttpRequest $request, ModelAndView $mav) {
      $mav->putParameter(self::AVAILABLE_AS, $request->getParameter(self::AVAILABLE_AS));
  }

  public function preHandle(HttpRequest $request) {
    try {
      $loggedUser = $this->userService->getLoggedUser();
    } catch (\Exception $exc) {
      $loggedUser = null;
    }

    $request->setSessionParameter(self::AVAILABLE_AS, $loggedUser);
    $request->addParameter(self::AVAILABLE_AS, $loggedUser);
  }
}
