<?php
namespace IZON\Users\Web\Interceptors;

use IZON\MVC\HttpRequest;
use IZON\MVC\ModelAndView;

use IZON\Users\Dao\UserDao;
use IZON\Users\Dao\UserRoleDao;
use IZON\Users\Dao\RoleDao;
use IZON\Users\Services\SessionService;

/**
 * Nastavuje informace o prihlasenem uzivateli
 *
 * @author Vítězslav Jahn <jahn@izon.cz>
 * @deprecated From always
 */
class WebBaseUserInterceptor {

  /**
   * Pod jakym nazvem je informace o uzivateli dostupna
   */
  const AVAILABLE_AS  = '_loggedUser';
  /**
   *
   * @var UserDao
   */
  protected $userDao;
  /**
   *
   * @var UserRoleDao
   */
  protected $userRoleDao;
  /**
   *
   * @var RoleDao
   */
  protected $roleDao;
  
  /**
   *
   * @var SessionService
   */
  protected $sessionService;
  

  public function __construct(SessionService $sessionService,
                              UserDao $userDao, 
                              UserRoleDao $userRoleDao,
                              RoleDao $roleDao
                              ) {
    $this->userDao      = $userDao;
    $this->userRoleDao  = $userRoleDao;
    $this->roleDao      = $roleDao;
    $this->sessionService = $sessionService;
  }
  
  public function afterCompletion(HttpRequest $request, $exception) {
      
  }

  public function postHandle(HttpRequest $request, ModelAndView $mav) {
      $mav->putParameter(self::AVAILABLE_AS, $request->getParameter(self::AVAILABLE_AS));
  }

  public function preHandle(HttpRequest $request) {
    try {
      $loggedUser = $this->sessionService->getLoggedUser();
    } catch (\Exception $exc) {
      $loggedUser = null;
    }

    $request->setSessionParameter(self::AVAILABLE_AS, $loggedUser);
    $request->addParameter(self::AVAILABLE_AS, $loggedUser);
  }
}
