<?php

namespace IZON\Users\DB;

use IZON\DB\QueryHelpers;
use IZON\DB\QueryFactory;

use IZON\Users\Domain\UserRole;

/**
 * 
 */
class UserQueryFactory implements QueryFactory {
    
    /**
     * Vraci vsechny aktivni konstrukce
     * @param QueryHelpers
     */
    public function findUserByLogin_1(QueryHelpers $queryHelpers) {
        return 'select '. $queryHelpers->getClassProperties("u")  
               .' from '. $queryHelpers->getTableName("u") 
               .' where '. $queryHelpers->getCoumnName("login") ." = :arg0  limit :maxResults offset :firstResult";
    }
//    
//    /**
//     * Vraci uzivatele podle aktivity
//     * @param QueryHelpers
//     */
//    public function findUserByActive_1(QueryHelpers $queryHelpers) {
//        return 'select '. $queryHelpers->getClassProperties("u")  
//               .' from '. $queryHelpers->getTableName("u") 
//               .' where '. $queryHelpers->getCoumnName("active") ." = :arg0  limit :maxResults offset :firstResult";
//    }
//    /**
//     * Vraci uzivatele podle aktivity
//     * @param QueryHelpers
//     */
//    public function findUsersByName_1(QueryHelpers $queryHelpers) {
//        return 'select '. $queryHelpers->getClassProperties("u")  
//               .' from '. $queryHelpers->getTableName("u") 
//               .' where '. $queryHelpers->getCoumnName("name") ." like :arg0  limit :maxResults offset :firstResult";
//    }
//    public function findUsersByEmail_1(QueryHelpers $queryHelpers) {
//        return 'select '. $queryHelpers->getClassProperties("u")  
//               .' from '. $queryHelpers->getTableName("u") 
//               .' where '. $queryHelpers->getCoumnName("email") ." like :arg0  limit :maxResults offset :firstResult";
//    }
    
    /**
     * Vraci uzivatele polde role
     * @param QueryHelpers
     */
    public function findUsersByRole_1(QueryHelpers $queryHelpers) {
        return "select ". $queryHelpers->getClassProperties("a") 
                ." from ". $queryHelpers->getTableName("a")
                ." join ". $queryHelpers->getClassTableName(UserRole::class, "b") 
                        ." on ". $queryHelpers->getCoumnName("id", "a") ." = ". $queryHelpers->getClassCoumnName(UserRole::class, "fkRoleId", "b")
                ." where ". $queryHelpers->getClassCoumnName(UserRole::class, "fkUserId", "b") ." = :arg0"
                ." limit :maxResults offset :firstResult";
    }
}
