<?php

namespace IZON\Users\Web\Controllers;

use \Exception;

use IZON\Mailer\Exceptions\MailException;
use IZON\Users\Services\SessionService;

use IZON\MVC\Controller;
use IZON\MVC\HttpRequest;
use IZON\MVC\ModelAndView;

use IZON\Forms\Form;

use IZON\Users\Web\Forms\UserWebFormFactory;


/**
 * 
 */
class ForgottenPasswordController implements Controller {
    
    /**
     * @var SessionService
     */
    protected $sessionService;
    
    /**
     * jake view se ma pouzit pro zobrazeni formulare
     * @var string 
     */
    protected $formViewName = "forgotten-password";


    public function __construct(SessionService $sessionService, $formViewName) {
        $this->sessionService = $sessionService;
        $this->formViewName = $formViewName;
    }
    
    public function execute(HttpRequest $request) {
        $sent = $request->hasParameter("sent");
        
        $modelAndView = new ModelAndView($this->formViewName);
        
        $form = UserWebFormFactory::forgottenPasswordForm();
        $modelAndView->putParameter("form", $form);
        
        if( $sent ) {
            $form->setValues($request->getParameters());
            
            $form->validate();
            if( $form->hasErrors() ) {
                return $modelAndView;
            }
            
            $email = $form->getField('email')->parse();
            
            try {
                $this->sessionService->handleForgottenPasswordEmail($email);
                $modelAndView->putParameter("message", _("Požadavek na reset hesla pro účet $email byl zaslán na Váš email."));                
                return $modelAndView;
            } catch (MailException $e) {
                $modelAndView->putParameter("message", _("Nepodařilo se odeslat email ma adresu $email. Zkuste to prosím později"));
                return $modelAndView;
            } catch (\Exception $e) {
                //var_dump($e);
                $form->getField('email')->addError(_("Email není registrován."));
                return $modelAndView;
            }
        } else {
            return $modelAndView;
        }
    }
}