<?php

namespace IZON\Users\Web\Forms;

use IZON\Forms\Form;

use IZON\Users\Forms\UserFormFactory;

/**
 * factory pro vytvareni formularu pro uzivatel
 */
class UserWebFormFactory extends UserFormFactory {
    
    public static function createUserForm() {
        $form = new Form();
        $form->addIdField("id", _("Id"));
        $form->addCharField("name", _("Jméno"));
        $form->addCharField("login", _("Login"));
        $form->addEmailField("email", _("Email"));
        $form->addCheckboxField("active", _("Povolený"));
        
        return $form;
    }
    
    public static function createUserRegistrationForm() {
        $form = new Form();
        $form->addEmailField("email", _("Email"))->setRequired(true);
        $form->addPasswordField("password", _("Heslo"))->setRequired(true);
        $form->addPasswordField("repeatPassword", _("Heslo znova"));
        
        return $form;
    }
    
    public static function createLoginForm() {
        $form = new Form();
        $form->addCharField("login", _("Login"));
        $form->addPasswordField("password", _("Heslo"));
        
        return $form;
    }
    
    public static function createChangePasswordForm() {
        $form = new Form();
        $form->addIdField("id", _("Id"));
        $form->addPasswordField("password", _("Heslo"))->setRequired(true);
        $form->addPasswordField("repeatPassword", _("Heslo znova"))->setRequired(true);
        
        return $form;
    }
    
    public static function forgottenPasswordForm() {
        $form = new Form();
        $form->addEmailField('email', 'Váš email')->setRequired(true);

        return $form;
    }

    public static function createResetPasswordForm($minPasswordLength) {
        $form = new Form();
        $form->addHiddenField("login", _("Email"))->setRequired(true);
        $form->addHiddenField("hash", _("Hash"))->setRequired(true);

        $passwordField = $form->addPasswordField("password", _("Heslo"))->setRequired(true);
        $repeatPasswordField = $form->addPasswordField("repeatPassword", _("Heslo znova"))->setRequired(true);
        
        // pravidlo pro min. delku hesla
        $functionLength = function(\IZON\Forms\Fields\PasswordField $field, $args) {
            return mb_strlen($field->parse(), 'UTF8') >= $args["minPasswordLength"];
        };
        $ruleLenght = new \IZON\Forms\ValidationRule($functionLength, 
                sprintf(_('Heslo je příliš krátké. Dělka hesla musí být minimálne %s znaků.'), $minPasswordLength), 
                ["minPasswordLength" => $minPasswordLength]);
        $passwordField->addRule($ruleLenght);

        // validuje jestli jsou heslo a opakovane heslo stejne
        $formValidator = function(Form $form) {
            $passwordField = $form->getField("password");
            $repeatPasswordField = $form->getField("repeatPassword");
            if( $passwordField->parse() != $repeatPasswordField->parse() ) {
                $passwordField->addError(__('Nové heslo a potvrzení hesla musí být stejné.'));
                $repeatPasswordField->addError(__('Nové heslo a potvrzení hesla musí být stejné.'));
            }
        };
        $form->setValidator($formValidator);
        
        
        return $form;
    }
}
