<?php

namespace IZON\Users\Web\Controllers;

use IZON\Users\Services\SessionService;

use IZON\MVC\Controller;
use IZON\MVC\HttpRequest;
use IZON\MVC\ModelAndView;
use IZON\MVC\Json\JsonResponse;

/**
 * 
 */
class LogoutController implements Controller {
    
    /**
     * @var SessionService
     */
    protected $sessionService;
    
    /**
     * defaultni controller na ktery sa ma po loginu presmerovat
     * @var string
     */
    protected $redirectControllerIdentifier = NULL;

    
    public function __construct(SessionService $sessionService) {
        $this->sessionService = $sessionService;
    }
    
    public function execute(HttpRequest $request) {
        $this->sessionService->logoutUser();
        $modelAndView = ModelAndView::createControllerRedirect($this->redirectControllerIdentifier);
        return $modelAndView;
    }
    
    
    public function ajaxLogout(HttpRequest $request) {
        $this->sessionService->logoutUser();
        
        $modelAndView = new ModelAndView("simple/json-respose");
        
        $result = JsonResponse::createResponse("logout");
        $modelAndView->putParameter("json", $result);
        
        return $modelAndView;
    }
    
    function setRedirectControllerIdentifier($redirectControllerIdentifier) {
        $this->redirectControllerIdentifier = $redirectControllerIdentifier;
    }
}
