<?php

namespace IZON\Users\Web\Controllers;

use \Exception;

use IZON\Users\Services\SessionService;

use IZON\MVC\Controller;
use IZON\MVC\HttpRequest;
use IZON\MVC\ModelAndView;
use IZON\MVC\Json\JsonResponse;

use IZON\Forms\Form;

use IZON\Users\Web\Forms\UserWebFormFactory;

use IZON\Users\Domain\User;

/**
 * 
 */
class LoginController implements Controller {
    
    /**
     * @var SessionService
     */
    protected $sessionService;
    
    /**
     * controoler na ktery se ma po prihlaseni presmerovat
     * @var string
     */
    protected $redirectControllerIdentifier = NULL;
    
    /**
     * jake view se ma pouzit pro zobrazeni formulare
     * @var string 
     */
    protected $loginFormViewName = "users/unlogged/login";

    
    public function __construct(SessionService $sessionService) {
        $this->sessionService = $sessionService;
    }
    
    public function execute(HttpRequest $request) {
        $loginForm = $this->createLoginForm($request);
        $loginForm->setValues($request->getParameters());
      //$this->sessionService->logoutUser();
        // neni vyplneny zadny login
        if( $loginForm->getField("login")->parse() == '' ) {
            $modelAndView = new ModelAndView($this->loginFormViewName, ["loginForm" => $loginForm]);
            return $modelAndView;
        }
        
        // pokusit se prihlasit
        try {
            $this->sessionService->loginUser($loginForm->getField("login")->parse(), 
                                                $loginForm->getField("password")->parse());
            $modelAndView = new ModelAndView($this->redirectControllerIdentifier, [], true);
            return $modelAndView;
        } catch(Exception $e) {
            $modelAndView = new ModelAndView($this->loginFormViewName, ["loginForm" => $loginForm, "loginError" => true]);
        }
        
        return $modelAndView;
    }
    
    public function ajaxLogin(HttpRequest $request) {
        $loginForm = $this->createLoginForm($request);
        $loginForm->setValues($request->getParameters());
        
        $login = $loginForm->getField("login")->parse();
        $password = $loginForm->getField("password")->parse();
        
        $modelAndView = new ModelAndView("simple/json-respose");
        
        try {
            $this->sessionService->loginUser($login, $password);
        } catch(Exception $exception) {
            $result = JsonResponse::createErrorResponse($exception->getMessage());
            $modelAndView->putParameter("json", $result);
            return $modelAndView;
        }
        
        $user = $this->sessionService->getLoggedUser();
        
        $result = JsonResponse::createResponse($this->serializeUserInfo($user));
        $modelAndView->putParameter("json", $result);
        
        return $modelAndView;
    }
    
    function setRedirectControllerIdentifier($redirectControllerIdentifier) {
        $this->redirectControllerIdentifier = $redirectControllerIdentifier;
    }

  function setLoginFormViewName($loginFormViewName) {
    $this->loginFormViewName = $loginFormViewName;
  }
    
    protected function createLoginForm(HttpRequest $request) {
        return UserWebFormFactory::createLoginForm();
    }
    
    protected function serializeUserInfo(User $user) {
        $usetArray = [
            "name" => $user->getName(),
        ];
        return $usetArray;
    }
    
    protected function getFormErrorArray(Form $form) {
        $errors = [];
        foreach($form->getFileds() as $fild) {
            if( $fild->hasErrors() ) {
                $errorsArray = $fild->getErrors();
                $errors[] = ["formName" => $fild->getFormName(), "errors" => $errorsArray];
            }
        }
        return $errors;
    }
}
