<?php

namespace IZON\Users\Web\Controllers;

use \Exception;

use IZON\Users\Services\SessionService;

use IZON\MVC\Controller;
use IZON\MVC\HttpRequest;
use IZON\MVC\ModelAndView;

use IZON\Forms\Form;

use IZON\Users\Web\Forms\UserWebFormFactory;

/**
 * 
 */
class ChangePasswordController implements Controller {
    
    /**
     * @var SessionService
     */
    protected $sessionService;
    
    /**
     * controoler na ktery se ma po prihlaseni presmerovat
     * @var string
     */
    protected $redirectControllerIdentifier = NULL;
    
    /**
     * jake view se ma pouzit pro zobrazeni formulare
     * @var string 
     */
    protected $formViewName = "users/change-password";
    
    public function __construct(SessionService $sessionService, $formViewName) {
        $this->sessionService = $sessionService;
        $this->formViewName = $formViewName;
    }
    
    public function execute(HttpRequest $request) {
        if( !$this->sessionService->isUserLoggedIn() ) {
            throw new Exception("Uživatel není přihlášen.");
        }
        
        $changePasswordForm = $this->createChangePasswordForm($request);
        
        if( !$request->hasParameter("_submited") ) {
            $modelAndView = new ModelAndView($this->formViewName, ["changePasswordForm" => $changePasswordForm]);
            return $modelAndView;
        }
        
        $changePasswordForm->setValues($request->getParameters());
        
        $password = $changePasswordForm->getField("password")->parse();
        $repeatPassword = $changePasswordForm->getField("repeatPassword")->parse();
        
        // heslo je kratke
        if( mb_strlen($password) < $this->sessionService->getMinPasswordLength() ) {
            $changePasswordForm->getField("password")->addError(sprintf(_("Minimální délka hesla je %d"), $this->sessionService->getMinPasswordLength()) );
        }
        
        if( $password != $repeatPassword ) {
            $changePasswordForm->getField("repeatPassword")->addError( _("Zadaná hesla se neshodují.") );
        }
        
        if( $changePasswordForm->hasErrors() ) {
            $modelAndView = new ModelAndView($this->formViewName, ["changePasswordForm" => $changePasswordForm]);
            return $modelAndView;
        }
        
        // pokusit se zmenit heslo
        try {
            $this->sessionService->changeLogedUserPassword($password);
            $modelAndView = new ModelAndView($this->redirectControllerIdentifier, [], true);
            return $modelAndView;
        } catch(Exception $e) {
            $modelAndView = new ModelAndView($this->formViewName, ["changePasswordForm" => $changePasswordForm, "changePasswordError" => true]);
        }
        
        return $modelAndView;
    }
    
    /**
     * 
     * @param HttpRequest $request
     * @return Form
     */
    protected function createChangePasswordForm(HttpRequest $request) {
        return UserWebFormFactory::createChangePasswordForm();
    }
    
    function setRedirectControllerIdentifier($redirectControllerIdentifier) {
        $this->redirectControllerIdentifier = $redirectControllerIdentifier;
    }
}