<?php

namespace IZON\Users\Services;

use IZON\Users\Domain\User;

/**
 * Servis slouzici k udrzovani iformaci o prihlasenem uzivateli a
 * k prihlaseni a odhlaseni uzivatele
 */
interface SessionService {
    
    /**
     * prihlasi uzivatele nebo vyhodi vyjimu proc to neni mozne
     * @param string $login
     * @param string $password
     */
    public function loginUser($login, $password);
    
    /**
     * odhlasi v soucasnosti prihlaseneho uzivatele
     */
    public function logoutUser();
    
    /**
     * vraci true pokud je do aplikace prihlsen uzivatel
     * @return boolean
     */
    public function isUserLoggedIn();
    
    /**
     * @return User currently logged user
     * @throws Exception if user isn't logged in
     */
    public function getLoggedUser();
    
    /**
     * nastavi prihlaseneho uzivatele
     * @param User $user
     */
    public function setLoggedUser(User $user);


    /**
     * is old password correct
     * @param string $password
     */
    public function isLoggedPasswordCorrect($password);
    
    /**
     * zmeni heslo prihlasenemu uzivateli
     * @param string $password
     */
    public function changeLogedUserPassword($password);
    
    /**
     * vrati hash hesla
     * @param string $password
     */
    public function getPasswordHash($password);

    /**
     * minimalni pozadovana delka hesla
     */
    function getMinPasswordLength();
    
}
