<?php

namespace IZON\Users\Domain;

use \IZON\Utils\Date;
use \IZON\DB\DBObject;

/**
 * nejaka reference o firme
 */
class User implements DBObject {

    const MIN_PASSWD_LENGHT = 5;
//    public static function __tableName() { return "refs"; }

    /**
     *
     * @var integer 
     */
    protected $id;
//    public static function __id() { return "blah3333"; }

    /**
     * 
     * @var string jmeno uzivatel pro zobrazeni
     */
    protected $name;
//    public static function __name() { return IZON\DB\charField(['maxLength' => 255]); }

    /**
     *
     * @var string login uzivatele
     */
    protected $login;

    /**
     *
     * @var string heslo uzivatele
     */
    protected $password;

    /**
     * @var string email uzivatele
     */
    protected $email;

    /**
     *
     * @var Date datum registrace uzivatele
     */
    protected $registrationDate;

    /**
     * @var Date datum posledniho prihlaseni o aplikace
     */
    protected $lastLoginDate;
    public static function __lastLoginDate() { return \IZON\DB\dateTimeField(['notNull' => false]); }
    
    /**
     * Jestli se aktivni
     * @var boolean
     */
    protected $active;
    
    /**
     * @var array Role role tohoto uzivatele
     */
    protected $roles = [];
    public static function __roles() { return \IZON\DB\transientField(); }
    
    /**
     * @var array UserAditionalInfo dalsi informace pripojene k tomuto uzivateli
     */
    protected $userAditionalInfos = [];
    public static function __userAditionalInfos() { return \IZON\DB\transientField(); }
    
    /**
     * @var array UserExternalLogin externi prihlaseni
     */
    protected $userExternalLogins = [];
    public static function __userExternalLogins() { return \IZON\DB\transientField(); }
    
    

// generovane gettery a settery
    function getId() {
        return $this->id;
    }
    
    function getLogin() {
        return $this->login;
    }

    function getPassword() {
        return $this->password;
    }

    function getEmail() {
        return $this->email;
    }

    function getActive() {
        return $this->active;
    }

    function setId($id) {
        $this->id = $id;
    }

    function setLogin($login) {
        $this->login = $login;
    }

    function setPassword($password) {
        $this->password = $password;
    }

    function setEmail($email) {
        $this->email = $email;
    }

    function setActive($active) {
        $this->active = $active;
    }
    
    function getName() {
        return $this->name;
    }

    function setName($name) {
        $this->name = $name;
    }
    
    function getRegistrationDate() {
        return $this->registrationDate;
    }

    function setRegistrationDate(Date $registrationDate) {
        $this->registrationDate = $registrationDate;
    }
    
    function getLastLoginDate() {
        return $this->lastLoginDate;
    }

    function setLastLoginDate(Date $lastLoginDate) {
        $this->lastLoginDate = $lastLoginDate;
    }
    
    function getUserExternalLogins() {
        return $this->userExternalLogins;
    }

    function setUserExternalLogins(array $userExternalLogins) {
        $this->userExternalLogins = $userExternalLogins;
    }
    
    function addUserExternalLogin(UserExternalLogin $userExternalLogin) {
        $this->userExternalLogins[] = $userExternalLogin;
    }
    
    function getRoles() {
        return $this->roles;
    }
    
    function setRoles(array $roles) {
        $this->roles = $roles;
    }
    
    function getUserAditionalInfos() {
        return $this->userAditionalInfos;
    }
    
    function setUserAditionalInfos(array $userAditionalInfos) {
        $this->userAditionalInfos = $userAditionalInfos;
    }
}
