<?php
namespace IZON\Users\Dao;

use IZON\DB\Dao;
use IZON\DB\QueryResult;

use \IZON\Users\Domain\User;

interface UserDao extends Dao {
    
    /**
     * pro jakou tridu se toto dao pouziva
     */
    const DOMAIN_CLASS = User::class;
    
    /**
     * Vraci uzivatele se stejnym loginem
     * @return QueryResult
     */
    public function findUserByLogin($login);
    
    /**
     * Vraci uzivatele podle emailu
     * @return QueryResult
     */
    public function findUsersByEmail($email);
}