<?php

namespace IZON\Users\Admin\Controllers;

use \IZON\Utils\Date;

use \IZON\MVC\Controller;
use \IZON\MVC\HttpRequest;
use \IZON\MVC\ModelAndView;

use IZON\Forms\Form;

use IZON\Admin\Web\Controllers\SimpleAdminController;

use \IZON\truckjobs\Clanky\Domain\Clanky;

/**
 * TODO: asi pouzivat specialni controller pro admin
 */
class UserController extends SimpleAdminController {
  
    protected function createForm() {
        $form = new Form();
        $form->addCharField("id", "Id");
        $form->addCharField("name", "Název");
        $form->addCharField("referenceCategoryId", "Kategorie");
        $form->addCharField("quote", "Poznámka");
        $form->addFileField("image", "Obrázek");
        $form->addDateFiled("date", "Datum realizace")->setDateFormat('Y');
        $form->addCheckboxField("active", "Zobrazovat");
        
        // TODO: pridat editaci data
        
        return $form;
    }

    protected function createDomainObject() {
        $reference = new Clanky();
        
        $reference->setId(NULL);
        $reference->setClankyCategoryId(1);
        $reference->setSubjectName("");
        $reference->setUrl("");
        $reference->setActive(true);
        $reference->setDate(new \IZON\Utils\Date());
        $reference->setClankyOrder(0);
        
        return $reference;
    }

    protected function loadData(ModelAndView $modelAndView) {
        $categories = $this->adminService->getActiveClankyCategories();
        $catAsocArray = [];
        foreach($categories as $category) {
            $catAsocArray[$category->getId()] = $category;
        }

        $modelAndView->putParameter("referenceCategoriesAsocArray", $catAsocArray);
    }
}