<?php

namespace IZON\UserAgent;

use WhichBrowser\Parser;

/**
 *
 */
class UserAgent {

    /**
     * @var Parser
     */
    protected $parser;

    /**
     * @param Parser $parser
     */
    public function __construct(Parser $parser) {
        $this->parser = $parser;
    }

    /**
     * Check the name of the browser and optionally is a specific version
     *
     * @param  string $browserName  The name of the browser that is checked
     * @param  string|null $operator  Optional, the operator, must be <, <=, =, >= or >
     * @param  mixed  $version  Optional, the value, can be an integer, float or string with a version number
     *
     * @return boolean
     */
    public function isBrowser(string $browserName, string $operator = null, $version = null): bool {
        if( $operator !== null && $version !== null ) {
            return $this->parser->isBrowser($browserName, $operator, $version);
        } else if( $operator !== null ) {
            return $this->parser->isBrowser($browserName, $operator);
        }
        return $this->parser->isBrowser($browserName);
    }

    /**
     * @return string
     */
    public function getBrowserName() : string {
        $name = $this->parser->browser->name;
        if(empty($name)) {
            $name = '';
        }
        return $name;
    }

    /**
     * @return string
     */
    public function getBrowserVersion() : string {
        $version = $this->parser->browser->getVersion();
        if(empty($version)) {
            $version = '';
        }
        return $version;
    }

    /**
     * Check the name of the operating system and optionally is a specific version
     *
     * @param  string $osName  The name of the operating system that is checked
     * @param  string|null $operator  Optional, the operator, must be <, <=, =, >= or >
     * @param  mixed $version   Optional, the value, can be an integer, float or string with a version number
     * @return bool
     */
    public function isOS(string $osName, string $operator = null, $version = null): bool {
        if( $operator !== null && $version !== null ) {
            return $this->parser->isOs($osName, $operator, $version);
        } else if( $operator !== null ) {
            return $this->parser->isOs($osName, $operator);
        }
        return $this->parser->isOs($osName);
    }

    /**
     * @return string returns Operating system family
     */
    public function getOS(): Os {
        return new Os($this->parser->os);
    }

    /**
     * Check if the detected browser is of the specified type
     *
     * @param  string   The type, or a combination of type and subtype joined with a semicolon.
     * @param  string   Unlimited optional types to check
     *
     * @return boolean
     */
    public function isType(string ... $types) {
        return call_user_func_array([ $this->parser, 'isType' ], $types);
    }
}
