<?php

namespace IZON\UserAgent;


use IZON\Logs\Exceptions\UserAgentParseException;
use Psr\Cache\CacheItemPoolInterface;
use WhichBrowser\Parser;


/**
 *
 */
class UserAgentParser {

    /**
     * @var CacheItemPoolInterface|null
     */
    protected static $cache = null;

    /**
     * parse user agent string of array of headers containg user agent
     * @param string|array $userAgentString
     * @return UserAgent
     * @throws UserAgentParseException
     */
    public static function parse($userAgentData) {
        try {
            $parser = self::getParser();
            $parser->analyse($userAgentData);
            $userAgent = new UserAgent($parser);
            return $userAgent;
        } catch (Throwable $ex) {
            throw new UserAgentParseException('could not parse browser', ['exception' => $ex]);
        }
    }

    public static function setCache(CacheItemPoolInterface $cache) {
        self::$cache = $cache;
    }

    protected static function getParser(): Parser {
        $parser = new Parser();
        if( self::$cache !== null ) {
            $parser->setCache(self::$cache);
        }
        return $parser;
    }
}
