<?php

namespace IZON\Transliterator\Tests;

use IZON\Transliterator\SlugUtils;
use PHPUnit\Framework\TestCase;

/**
 * @covers \IZON\Transliterator\Slug
 */
class SlugUtilsTest extends TestCase
{
    public function testCreate(): void
    {
        $slug = SlugUtils::createSlug('Příliš žluťoučký kůň úpěl ďábelské ódy');
        $this->assertEquals(1, preg_match('/^[a-z0-9-]+$/', $slug)); // contains only ascii chars, numbers and hyphens
        $this->assertGreaterThan(10, mb_strlen($slug)); // at least 10 characters remain in slug

        $slug = SlugUtils::createSlug('I ♥ Dogs');
        $this->assertEquals(1, preg_match('/^[a-z0-9-]+$/', $slug)); // contains only ascii chars, numbers and hyphens
        $this->assertGreaterThan(5, mb_strlen($slug)); // at least 10 characters remain in slug

        $slug = SlugUtils::createSlug('я люблю единорогов');
        $this->assertEquals(1, preg_match('/^[a-z0-9-]+$/', $slug)); // contains only ascii chars, numbers and hyphens
        $this->assertGreaterThan(10, mb_strlen($slug)); // at least 10 characters remain in slug
    }
}
