<?php

namespace IZON\Transliterator;

use Behat\Transliterator\Transliterator;

/**
 * creates slug
 */
abstract class SlugUtils
{
    /**
     * Return URL-friendly string without diacritics, spaces and dangerous chars
     * @param string $name
     * @return string
     */
    public static function createSlug(string $name): string
    {
        return Transliterator::transliterate($name);
    }

    /**
     * Check if string is URL-friendly and can be used as a slug
     * @param string $string
     * @return boolean
     */
    public static function isSlug(string $string): bool
    {
        $result = preg_match('/^[a-z0-9-]+$/', $string);
        if ($result === 1) {
            return true;
        }
        return false;
    }
}
