<?php

namespace IZON\Transliterator;


/**
 * creates slug
 */
abstract class Slug {

    /**
     * vrati retezec ocesany o diakritiku, mezery (nahrazeny -) a o vsecky skarede znaky
     * Return string without diacritics, spaces and dangerous chars
     * @staticvar array $convertTable
     * @param string $name
     * @return string
     */
    public static function createSlug($name) {
        return \Behat\Transliterator\Transliterator::transliterate($name);
    }

    /**
     * Zkontroloje jestli je řetezec ve bezpecném tvar (slug)
     * Check if string is safe, string is slug
     * @param string $string
     * @return boolean
     */
    public static function isStringSlug($string) {
        $result = preg_match('/^[a-z0-9-]+$/', $string);
        if( !empty($result) ) {
            return true;
        }
        return false;
    }

}
