<?php

namespace IZON\Thumber\Web\Utils;


use IZON\UserAgent\UserAgentParser;

class WebPImageUtils {

    /**
     * @param array $headers
     * @return bool
     */
    public static function hasWebPSupport(array $headers) {
        if((isset($headers['accept']) === true) && (strstr($headers['accept'], 'image/webp') !== false)) {
            return true;
        }

        // try to detect agents with WebP support for lossy, lossless & alpha
        // support list taken fom https://developers.google.com/speed/webp/faq
        try {
            $userAgent = UserAgentParser::parse($headers);
            if(
                $userAgent->isBrowser('Chrome', '>=', 23) && $userAgent->isType('desktop')  // Google Chrome (desktop) 23+
                || ( $userAgent->isBrowser('Chrome', '>=', 25)
                        && $userAgent->getOS()->getName() == 'Android' ) // Google Chrome for Android version 25+
                || $userAgent->isBrowser('Edge', '>=', 18) // Microsoft Edge 18+
                || $userAgent->isBrowser('Firefox', '>=', 65) // Firefox 65+
                || $userAgent->isBrowser('Opera', '>=', '12.10') // Opera 12.10+
                || $userAgent->isBrowser('Pale Moon', '>=', 26) // Pale Moon 26+
            ) {
                return true;
            }
        } catch(UserAgentParseException $exception) {
            // let the exception slide
        }

        return false;
    }
}