<?php

namespace IZON\Thumber\Services;


use IZON\IO\Image;
use IZON\IO\RasterImageInterface;
use IZON\Thumber\Image\IImageURLBuilder;
use IZON\Thumber\ImageConfiguration\IImageConfiguration;
use IZON\Thumber\Thumbnailer;


/**
 * servis pro vytvareni nahledu
 */
interface ThumbnailServiceInterface {



    /**
     * factory for thumber
     * @return Thumbnailer
     */
    public function getThumbnailer();

    /**
     * @return IImageURLBuilder builder that creates url for thumber configuretion
     */
    public function getImageURLBuiler(): IImageURLBuilder;

    /**
     * creates config for provided raster image and parameters
     * @param RasterImageInterface $sourceImage
     * @param array $parameters
     * @return IImageConfiguration
     */
    public function createThumbnailImageConfiguration(
        RasterImageInterface $sourceImage,
        array $parameters = []
    ): IImageConfiguration;

    /**
     * creates url for download of required thumbnail
     * @param IImageConfiguration $config
     * @return string path for image in cache
     */
    public function getThumbnailURL(IImageConfiguration $config): string;

    /**
     * creates thumbnail and returns url for download
     * @param IImageConfiguration $config
     * @return string path for image in cache
     */
    public function createThumbnail(IImageConfiguration $config): string;

    /**
     * @param string $imagePath
     * @return bool true if $imagePath existr on default file system
     */
    public function hasDefaultFileSystemImage(string $imagePath): bool ;

    /**
     * returns raster image grom default file system
     * @param string $imagePath
     * @return RasterImageInterface
     */
    public function getDefaultFileSystemImage(string $imagePath): RasterImageInterface;

    /**
     * sets output image format
     * @param string $format
     */
    public function setFormat(string $format): void;

    /**
     * @return RasterImageInterface|null
     */
    public function getNoImage(): ?RasterImageInterface;
}
