<?php

namespace IZON\Thumber\ImageConverter;

use Intervention\Image\ImageManager;
use IZON\IO\RasterImageInterface;

/**
 * Description of ImageCoverterFactory
 *
 * @author lukas
 */
class ImagineImageConverterFactory implements IImageConverterFactory {
    /**
     *
     * @var ImageManager
     */
    protected $imagine;
    /**
     *
     * @var string
     */
    protected $tmpDir;

    /**
     *
     * @param string $tmpDir
     * @param string $driver default 'gd' also supports 'imagemagick'
     */
    function __construct(string $tmpDir, string $driver = 'gd') {
        $this->imagine = new ImageManager(['driver' => $driver]);
        $this->tmpDir = $tmpDir;
    }

    /**
     *
     * @param RasterImageInterface $image
     * @return IImageConverter
     */
    public function createImageConverter(RasterImageInterface $image): IImageConverter {
        $iimage = $this->imagine->make($image->getFileStream());
        return new ImagineImageConverter($iimage, $this->tmpDir, $this->imagine);
    }

}
