<?php

namespace IZON\Thumber\ImageResizer;

use IZON\Thumber\Exceptions\UnsupportedResizeTypeException;

/**
 * Provides image size calculations.
 *
 * @author Aleš Kopecký <kopecky@izon.cz>
 */
interface IImageResizer
{
    /**
     *
     */
    public const CONTAIN = 'contain';
    /**
     *
     */
    public const COVER = 'cover';
    /**
     *
     */
    public const CROP = 'crop';
    /**
     *
     */
    public const SUPPORTED_TYPES = [
        self::CONTAIN,
        self::COVER,
        self::CROP,
    ];

    /**
     *
     * @param string $type
     * @return IImageResizerStrategy
     * @throws UnsupportedResizeTypeException
     */
    public function resize(string $type): IImageResizerStrategy;

    /**
     *
     * @param string $type
     * @param IImageResizerStrategy $strategy
     * @return IImageResizer
     * @throws UnsupportedResizeTypeException
     */
    public function addStrategy(string $type, IImageResizerStrategy $strategy): IImageResizer;
}
