<?php



namespace IZON\Thumber\Image;

use IZON\Thumber\Image\Exceptions\InvalidSizeException;
use IZON\Thumber\Utils\PixelSizeUtils;

/**
 * Description of ImageSize
 *
 * @author lukas
 */
class ImageSize implements IImageSize
{
    protected int $width;

    protected int $height;

    final protected function __construct()
    {
    }

    public static function create(int $width, int $height): ImageSize
    {
        $size = new static();

        if ($width <= 0 && $height <= 0) {
            throw new InvalidSizeException('Width and height must be greater then zero.');
        }
        if ($width <= 0) {
            throw new InvalidSizeException('Width must be greater then zero.');
        }
        if ($height <= 0) {
            throw new InvalidSizeException('Width must be greater then zero.');
        }
        $size->width = $width;
        $size->height = $height;
        return $size;
    }

    public static function createFromWidth(int $width, float $aspectRatio): ImageSize
    {
        $size = new static();
        $size->width = $width;

        // align height to the nearest integer
        $newHeight = $width * $aspectRatio;
        $size->height = PixelSizeUtils::getClosestPixelSize($newHeight);
        return $size;
    }

    public static function createFromHeight(int $height, float $aspectRatio): ImageSize
    {
        $size = new static();
        $size->height = $height;

        // align width to the nearest integer
        $newWidth = $height / $aspectRatio;
        $size->width = PixelSizeUtils::getClosestPixelSize($newWidth);

        return $size;
    }

    /**
     * return height/width
     * @return float
     */
    public function getAspectRatio(): float
    {
        return $this->height / $this->width;
    }

    public function getHeight(): int
    {
        return $this->height;
    }

    public function getWidth(): int
    {
        return $this->width;
    }
}
