<?php

namespace IZON\Thumber\ImageResizer;

use IZON\Thumber\Exceptions\InvalidResizerStrategyException;
use IZON\Thumber\Exceptions\UnsupportedResizeTypeException;

/**
 * Description of ImageResizer
 *
 * @author lukas
 */
class ImageResizer implements IImageResizer
{
    /**
     *
     * @var IImageResizerStrategy[]
     */
    protected array $strategies = [];

    /**
     *
     * @param array<string, IImageResizerStrategy> $strategies
     * @throws UnsupportedResizeTypeException
     * @throws InvalidResizerStrategyException
     */
    public function __construct(array $strategies = [])
    {
        foreach ($strategies as $type => $strategy) {
            if (!in_array($type, self::SUPPORTED_TYPES)) {
                throw new UnsupportedResizeTypeException("Type '$type' is not supported.");
            }
            if (!($strategy instanceof IImageResizerStrategy)) { // @phpstan-ignore instanceof.alwaysTrue
                $whatIs = gettype($strategy);
                throw new InvalidResizerStrategyException("Strategy for '$type' is not supported becouse it is $whatIs and not " . IImageResizerStrategy::class . ".");
            }
        }
        $this->strategies = $strategies;
    }

    /**
     *
     * @param string $type
     * @return IImageResizerStrategy
     * @throws UnsupportedResizeTypeException
     */
    public function resize(string $type): IImageResizerStrategy
    {
        if (!in_array($type, self::SUPPORTED_TYPES)) {
            throw new UnsupportedResizeTypeException("Type '$type' is not supported.");
        }
        if (!isset($this->strategies[$type])) {
            throw new UnsupportedResizeTypeException("Type '$type' is not setted.");
        }
        return $this->strategies[$type];
    }

    public function addStrategy(string $type, IImageResizerStrategy $strategy): IImageResizer
    {
        if (!in_array($type, self::SUPPORTED_TYPES)) {
            throw new UnsupportedResizeTypeException("Type '$type' is not supported.");
        }
        $this->strategies[$type] = $strategy;
        return $this;
    }
}
