<?php

namespace IZON\Thumber\ImageConverter;

use IZON\IO\Image;
use IZON\IO\RasterImageInterface;
use IZON\Thumber\Image\IImagePoint;
use IZON\Thumber\Image\IImageSize;

/**
 * Converts image into specified format.
 *
 * @author Aleš Kopecký <kopecky@izon.cz>
 */
interface IImageConverter
{
    public const EXTENSION_WEBP = 'webp';
    public const EXTENSION_JPG = 'jpg';
    public const EXTENSION_PNG = 'png';

    public const EXTENSIONS_AVAILABLE = [
        self::EXTENSION_WEBP,
        self::EXTENSION_JPG,
        self::EXTENSION_PNG
    ];

    /**
     * Sets ImageSize object.
     * @param IImageSize $imageSize Image size object containing image size info.
     * @return IImageConverter
     */
    public function setSize(IImageSize $imageSize): IImageConverter;

    /**
     * Sets quality.
     * @param int $quality
     * @return IImageConverter
     */
    public function setQuality(int $quality): IImageConverter;

    /**
     * Sets format.
     * @param string $format Use constants of IImageConverter interface.
     * @return IImageConverter
     */
    public function setFormat(string $format): IImageConverter;

    /**
     * set image to interlace
     * @param bool $interlace
     * @return IImageConverter
     */
    public function setInterlace(bool $interlace): IImageConverter;

    /**
     * @param string $fileName
     * @return RasterImageInterface
     */
    public function convert(string $fileName): RasterImageInterface;

    /**
     *
     * @param IImageSize $size
     * @param IImagePoint $point
     * @return IImageConverter
     */
    public function crop(IImageSize $size, IImagePoint $point): IImageConverter;

    /**
     * apply watermark to iamge
     * @param RasterImageInterface $watermarkImage
     * @param IImageSize $watermarkSize
     * @param string $alignment
     * @param IImagePoint $imagePosition
     * @return IImageConverter
     */
    public function watermark(
        RasterImageInterface $watermarkImage,
        IImageSize $watermarkSize,
        string $alignment,
        IImagePoint $imagePosition
    ): IImageConverter;

    /**
     * clears all resources needed for conversion and storage of RasterImageInterface
     * @param RasterImageInterface $convertedFile
     */
    public function destroyImage(RasterImageInterface $convertedFile): void;
}
