<?php

namespace IZON\Thumber\Web\Interceptors;

use IZON\MVC\Interceptors\InterceptorInterface;
use IZON\MVC\Messages\HttpRequestInterface;
use IZON\MVC\Messages\HttpResponseInterface;
use IZON\Thumber\Services\ThumbnailServiceInterface;
use IZON\Thumber\Thumbnailer;
use IZON\Thumber\Web\Utils\WebPImageUtils;

/**
 * nacita informace o ga
 */
class ThumberInterceptor implements InterceptorInterface
{
    protected ThumbnailServiceInterface $thumbnailService;

    protected bool $enableWebp;

    public function __construct(ThumbnailServiceInterface $thumbnailService, bool $enableWebp = true)
    {
        $this->thumbnailService = $thumbnailService;
        $this->enableWebp = $enableWebp;
    }

    public function afterCompletion(HttpRequestInterface $request, HttpResponseInterface $response, $exception): HttpResponseInterface
    {
        return $response;
    }

    public function preHandle(HttpRequestInterface $request): HttpRequestInterface
    {
        if (
            $this->enableWebp
            && WebPImageUtils::hasWebPSupport(getallheaders())
        ) {
            // Do something for WebP users
            $this->thumbnailService->setFormat('webp');
        }
        return $request;
    }

    public function postHandle(HttpRequestInterface $request, HttpResponseInterface $response): HttpResponseInterface
    {
        $modelAndView = $response->getModelAndView();
        if ($modelAndView === null) {
            return $response;
        }
        // adds information about gallery
        $modelAndView->putParameter(
            Thumbnailer::AVAILABLE_AS,
            $this->thumbnailService->getThumbnailer()
        );
        return $response;
    }
}
