<?php

namespace IZON\Thumber\Image;

use InvalidArgumentException;
use IZON\IO\RasterImageInterface;
use IZON\Thumber\Exceptions\FilesystemNotFoundException;
use IZON\Thumber\Exceptions\ImageNotFoundException;
use IZON\Thumber\Exceptions\UnsupportedImageTypeException;
use IZON\Thumber\ImageConfiguration\IImageConfiguration;

/**
 * IImageUrlBuilder
 * @author Aleš Kopecký <kopecky@izon.cz>
 */
interface IImageURLBuilder {

    /**
     * @param string $path
     */
    public function setPath(string $path);

    /**
     * Composes URL to image lazy generation controller based on given config.
     * @param IImageConfiguration $config
     * @return string
     */
    public function buildURL(IImageConfiguration $config): string;

    /**
     * Creates RasterImageInterface from parameters given in array
     * @param array $params
     * @return RasterImageInterface
     * @throws InvalidArgumentException
     * @throws UnsupportedImageTypeException
     * @throws FilesystemNotFoundException
     * @throws ImageNotFoundException
     */
    public function getImage(array $params): RasterImageInterface;

}
