<?php

namespace IZON\Thumber\ImageResizer\Strategies;

use IZON\Thumber\Image\IImageSize;
use IZON\Thumber\Image\ImageSize;
use IZON\Thumber\ImageResizer\IImageResizerStrategy;
use IZON\Thumber\Utils\PixelSizeUtils;

/**
 * ContainImageResizerStrategy computes contain image size
 *
 * @author lukas
 */
class ContainImageResizerStrategy implements IImageResizerStrategy {

    public static function getSize(IImageSize $imageSize, IImageSize $containerSize, bool $upsize = false): IImageSize {
        if($imageSize->getAspectRatio() > $containerSize->getAspectRatio()) {
            $height = $containerSize->getHeight();
            $width = PixelSizeUtils::getClosestPixelSize($height / $imageSize->getAspectRatio());
        } else {
            $width = $containerSize->getWidth();
            $height = PixelSizeUtils::getClosestPixelSize($width * $imageSize->getAspectRatio());
        }
        $isFinalBigger = $width > $imageSize->getWidth() || $height > $imageSize->getHeight();
        if(!$upsize && $isFinalBigger) {
            return $imageSize;
        }

        return ImageSize::create($width, $height);
    }

}
