<?php

namespace PHPView\Thumber;


use IZON\IO\RasterImageInterface;
use IZON\Thumber\Thumbnailer;

/**
 * Return image url for source path or Image object
 * @param RasterImageInterface|string $sourceImage source Image Object or path to image file with first "/" path_to_file
 * @param array<string, string|int|float> $parameters parameters for resizing of image, supported settings:<br>
 * width => integer, <br>height => integer, <br>type => [cover|contain], default is contain, <br>quality = number, default = 90<br>
 * for example: ["width" => 1234, "height" => 1234, "type" => "contain"]
 *
 */
function getThumbnail($sourceImage, array $parameters = []): string {
    /* @var Thumbnailer $thumbnailer  */
    $thumbnailer = \PHPView\getParameter(Thumbnailer::AVAILABLE_AS);
    return $thumbnailer->getThumbnailURL($sourceImage, $parameters);
//    return strtr($src, ["\t" => '%20', " " => '%20']);
}

/**
 * Only wrapper for getThumbnail, for more detail see there
 * @param RasterImageInterface|string $sourceImage source Image Object or path to image file with first "/"
 * @param array<string, string|int|float> $parameters parameters for resizing of image, supported settings:<br>
 * width => integer, <br>height => integer, <br>type => [cover|contain], default is contain, <br>quality = number, default = 90, max is 100 - create image without any compression<br>
 * for example: ["width" => 1234, "height" => 1234, "type" => "contain"]
 * @return string
 * @deprecated use getThumbnail instead
 */
function getThumb($sourceImage, array $parameters = []): string {
    return getThumbnail($sourceImage, $parameters);
}
