<?php

namespace IZON\Thumber\Web\Utils;


use IZON\UserAgent\Exceptions\UserAgentParseException;
use IZON\UserAgent\UserAgentParser;

class WebPImageUtils {

    /**
     * @param array<string, string> $headers
     * @return bool
     */
    public static function hasWebPSupport(array $headers): bool {
        $headers = self::normalizeHeadersArray($headers);

        if((isset($headers['accept']) === true) && (strstr($headers['accept'], 'image/webp') !== false)) {
            return true;
        }

        // try to detect agents with WebP support for lossy, lossless & alpha
        // support list taken fom https://developers.google.com/speed/webp/faq and https://caniuse.com/webp
        try {
            $userAgent = UserAgentParser::parse($headers);
            if(
                $userAgent->isBrowser('Chrome', '>=', 23) && $userAgent->isType('desktop')  // Google Chrome (desktop) 23+
                || $userAgent->isBrowser('Chrome', '>=', 25) && $userAgent->isOS('Android') // Google Chrome for Android version 25+
                || $userAgent->isBrowser('Firefox', '>=', 65) // Firefox 65+
                || $userAgent->isBrowser('Edge', '>=', 18) // Microsoft Edge 18+
                || $userAgent->isBrowser('Safari', '>=', 14) && $userAgent->isOS('OS X', '>=', '11')  // Safari 14+ on macOS
                || $userAgent->isBrowser('Safari', '>=', 14) && $userAgent->isOS('iOS')  // Safari 14+ on iOS
                || $userAgent->isBrowser('Opera', '>=', '12.10') // Opera 12.10+
                || $userAgent->isBrowser('Pale Moon', '>=', 26) // Pale Moon 26+
            ) {
                return true;
            }
        } catch(UserAgentParseException $exception) {
            // let the exception slide
        }

        return false;
    }

    /**
     * @param array<string, string> $headers
     * @return array<string, string>
     */
    public static function normalizeHeadersArray(array $headers): array {
        $outputHeaders = [];
        foreach($headers as $key => $value) {
            $outputHeaders[mb_strtolower($key)] = $value;
        }
        return $outputHeaders;
    }
}
