<?php

namespace IZON\Thumber\Web\Interceptors;


use IZON\MVC\HttpRequest;
use IZON\MVC\Interceptors\Interceptor;
use IZON\MVC\ModelAndView;
use IZON\Thumber\Services\ThumbnailServiceInterface;
use IZON\Thumber\Thumbnailer;
use IZON\Thumber\Web\Utils\WebPImageUtils;


/**
 * nacita informace o ga
 */
class ThumberInterceptor implements Interceptor {

    protected ThumbnailServiceInterface $thumbnailService;

    protected bool $enableWebp;

    public function __construct(ThumbnailServiceInterface $thumbnailService, bool $enableWebp = true) {
        $this->thumbnailService = $thumbnailService;
        $this->enableWebp = $enableWebp;
    }

    public function afterCompletion(HttpRequest $request, $exception) {

    }

    public function preHandle(HttpRequest $request) {
        if(
            $this->enableWebp
            && WebPImageUtils::hasWebPSupport(getallheaders())
        ) {
            // Do something for WebP users
            $this->thumbnailService->setFormat('webp');
        }
        return null;
    }

    /**
     * @param HttpRequest $request
     * @param ModelAndView $model
     * @return ModelAndView
     */
    public function postHandle(HttpRequest $request, ModelAndView $model) {
        // adds information about gallery
        $model->putParameter(Thumbnailer::AVAILABLE_AS, $this->thumbnailService->getThumbnailer());
        return $model;
    }
}
