<?php

/*
 * To change this license header, choose License Headers in Project Properties.
 * To change this template file, choose Tools | Templates
 * and open the template in the editor.
 */

namespace IZON\Thumber\Image;

use IZON\Thumber\Exceptions\ThumbnailException;

/**
 * Description of ImagePoint
 *
 * @author lukas
 */
class ImagePoint implements IImagePoint {
    /**
     *
     * @var int
     */
    protected $x;
    /**
     *
     * @var int
     */
    protected $y;
    
    public function __construct(int $x, int $y) {
        if($x < 0) {
            throw new ThumbnailException('x position of point is negative');
        }
        if($y < 0) {
            throw new ThumbnailException('y position of point is negative');
        }
        $this->x = $x;
        $this->y = $y;
        
    }
    
    public function getX() : int {
        return $this->x;
    }

    public function getY() : int {
        return $this->y;
    }



}
