<?php

namespace IZON\Thumber\ImageConfiguration;

use IZON\IO\Image;
use IZON\IO\RasterImageInterface;
use IZON\Thumber\Image\IImagePoint;
use IZON\Thumber\Image\IImageSize;

/**
 * IImageConfiguration
 * @author Aleš Kopecký <kopecky@izon.cz>
 */
interface IImageConfiguration {

    /**
     *
     * @param RasterImageInterface $image
     */
    public function setImage(RasterImageInterface $image);

    /**
     *
     * @param IImageSize $imageSize
     */
    public function setImageSize(IImageSize $imageSize);

    /**
     *
     * @param int $quality
     */
    public function setQuality(int $quality);

    /**
     *
     * @param string $type
     */
    public function setType(string $type);

    /**
     *
     * @param string $name
     */
    public function setName(string $name);

    /**
     *
     * @param IImageSize $size
     */
    public function setCropSize(IImageSize $size);

    /**
     *
     * @param IImagePoint $point
     */
    public function setCropPoint(IImagePoint $point);

    /**
     *
     * @return RasterImageInterface
     */
    public function getImage(): RasterImageInterface;

    /**
     *
     * @return IImageSize
     */
    public function getImageSize(): IImageSize;

    /**
     *
     * @return int
     */
    public function getWidth(): ?int;

    /**
     *
     * @return int
     */
    public function getHeight(): ?int;

    /**
     *
     * @return int
     */
    public function getQuality(): int;

    /**
     *
     * @return string
     */
    public function getType(): string;

    /**
     *
     * @return string
     */
    public function getName(): string;

    /**
     *
     * @return IImageSize|null
     */
    public function getCropSize(): ?IImageSize;

    /**
     *
     * @return IImagePoint|null
     */
    public function getCropPoint(): ?IImagePoint;

    /**
     * Checks if CropPoint and CropSize objects are set and correct type.
     * @return boolean
     */
    public function hasCrop(): bool;

    public function isCache(): bool;

    public function setCache(bool $cache);

    /**
     * @return RasterImageInterface|null
     */
    public function getWatermarkImage(): ?RasterImageInterface;

    /**
     * @param RasterImageInterface|null $watermarkImage
     */
    public function setWatermarkImage(?RasterImageInterface $watermarkImage): self;

    /**
     * @return IImageSize|null
     */
    public function getWatermarkSize(): ?IImageSize;

    /**
     * @param IImageSize|null $watermarkSize
     */
    public function setWatermarkSize(?IImageSize $watermarkSize): self;

    /**
     * @return string|null
     */
    public function getWatermarkAlignment(): ?string;

    /**
     * @param string|null $watermarkAlignment
     */
    public function setWatermarkAlignment(?string $watermarkAlignment): self;

    /**
     * @return IImagePoint|null
     */
    public function getWatermarkPosition(): ?IImagePoint;

    /**
     * @param IImagePoint|null $watermarkPosition
     */
    public function setWatermarkPosition(?IImagePoint $watermarkPosition): self;

    /**
    * @return bools
    */
    public function isLazy(): bool;

    /**
     * @param bool $lazy
     */
    public function setLazy(bool $lazy): self;

    /**
     * @return null|string image format to use
     */
    public function getFormat(): ?string;

    /**
     * @param null|string $format
     */
    public function setFormat(?string $format): IImageConfiguration;

    /**
     * @return null|string|int
     */
    public function getWatermark();

    /**
     * @param null|string|int $watermark
     */
    public function setWatermark($watermark): IImageConfiguration;
}
