<?php

namespace IZON\Thumber\ImageConverter;

use Intervention\Image\ImageManager;
use IZON\IO\RasterImageInterface;
use Intervention\Image\Image as InterventionImage;
use Intervention\Image\Gd\Driver as InterventionGdDriver;

/**
 * Description of ImageCoverterFactory
 *
 * @author lukas
 */
class ImagineImageConverterFactory implements IImageConverterFactory {
    /**
     *
     * @var ImageManager
     */
    protected $imagine;
    /**
     *
     * @var string
     */
    protected $tmpDir;

    /**
     *
     * @param string $tmpDir
     * @param string $driver default 'gd' also supports 'imagemagick'
     */
    function __construct(string $tmpDir, string $driver = 'gd') {
        $this->imagine = new ImageManager(['driver' => $driver]);
        $this->tmpDir = $tmpDir;
    }

    /**
     *
     * @param RasterImageInterface $image
     * @return IImageConverter
     */
    public function createImageConverter(RasterImageInterface $image): IImageConverter {
        $iimage = $this->imagine->make($image->getFileStream());
        $this->applyImageOrientation($iimage, $image);
        return new ImagineImageConverter($iimage, $this->tmpDir, $this->imagine);
    }

    /**
     * @param InterventionImage $image applies rotation to image if orientation exif data present
     */
    protected function applyImageOrientation(InterventionImage $image, RasterImageInterface $rasterImage) {
        if( version_compare(phpversion(), '7.2', '<') ) { // rotation do not work on php 7.1 and down as exif_read_data supports resource from php 7.2
            return;
        }
        $rotation = null;
        if( in_array($rasterImage->getMimeType(), ['image/jpeg']) ) {
            $exif = exif_read_data($rasterImage->getFileStream());
            if( !empty($exif['Orientation']) ) {
                switch($exif['Orientation']) {
                    case 3:
                        $rotation = 180;
                        break;
                    case 6:
                        $rotation = -90;
                        break;
                    case 8:
                        $rotation = 90;
                        break;
                }
            }
        }

        if( $rotation ) {
            $image->rotate($rotation);
        }
    }
}
