<?php
/**
 * image resizing functions
 */

namespace PHPView\Thumber;


/**
 * Return image url for source path or Image object
 * @param \IZON\IO\Image|string $sourceImage source Image Object or path to image file with first "/" path_to_file
 * @param array $parameters parameters for resizing of image, supported settings:<br>
 * width => integer, <br>height => integer, <br>type => [cover|contain], default is contain, <br>quality = number, default = 90<br>
 * for example: ["width" => 1234, "height" => 1234, "type" => "contain"]
 *
 */
function getThumbnail($sourceImage, array $parameters = []) {
    /* @var $thumbnailer \IZON\Thumber\Thumbnailer */
    $thumbnailer = \PHPView\getParameter(\IZON\Thumber\Thumbnailer::AVAILABLE_AS);
    $src = $thumbnailer->getThumbnailURL($sourceImage, $parameters);
    return $src;
}

/**
 * Only wrapper for getThumbnail, for more detail see there
 * @param \IZON\IO\Image|string $sourceImage source Image Object or path to image file with first "/"
 * @param array $parameters parameters for resizing of image, supported settings:<br>
 * width => integer, <br>height => integer, <br>type => [cover|contain], default is contain, <br>quality = number, default = 90, max is 100 - create image without any compression<br>
 * for example: ["width" => 1234, "height" => 1234, "type" => "contain"]
 * @return string
 */
function getThumb($sourceImage, array $parameters = []) {
    return getThumbnail($sourceImage, $parameters);
}