<?php

namespace IZON\Thumber\Image;

/**
 *
 * @author lukas
 */
interface IImageNameBuilder {

    /**
     *
     * @param IImageSize $size
     */
    public function setSize(IImageSize $size): IImageNameBuilder;

    /**
     *
     * @param int $quality
     */
    public function setQuality(int $quality): IImageNameBuilder;

    /**
     *
     * @param string $quality
     */
    public function setFormat(string $quality): IImageNameBuilder;

    /**
     *
     * @param string $type
     * @return IImageNameBuilder
     */
    public function setType(string $type): IImageNameBuilder;

    /**
     *
     * @param IImagePoint $point
     * @return IImageNameBuilder
     */
    public function setCropPoint(IImagePoint $point): IImageNameBuilder;

    /**
     *
     * @param IImageSize $size
     */
    public function setCropSize(IImageSize $size): IImageNameBuilder;

    /**
     * return builded name of file
     * @return string
     */
    public function build(): string;
}
