<?php

namespace IZON\Thumber\ImageConverter;

use Intervention\Image\ImageManager;
use IZON\IO\Image;

/**
 * Description of ImageCoverterFactory
 *
 * @author lukas
 */
class ImagineImageCoverterFactory implements IImageConverterFactory {
    /**
     *
     * @var ImageManager
     */
    protected $imagine;
    /**
     *
     * @var string
     */
    protected $tmpDir;

    /**
     * 
     * @param string $tmpDir
     * @param string $driver default 'gd' also supports 'imagemagick' 
     */
    function __construct(string $tmpDir, string $driver = 'gd') {
        $this->imagine = new ImageManager(['driver' => $driver]);
        $this->tmpDir = $tmpDir;
    }

    /**
     * 
     * @param Image $image
     * @return IImageConverter
     */
    public function createImageConverter(Image $image): IImageConverter {
        $iimage = $this->imagine->make($image->getFsPath());
        return new ImagineImageConverter($iimage, $this->tmpDir);
    }

}
