<?php

namespace IZON\Thumber\ImageConfiguration;

use IZON\IO\Image;
use IZON\Thumber\Image\IImagePoint;
use IZON\Thumber\Image\IImageSize;

/**
 * ImageConfiguration
 * @author Aleš Kopecký <kopecky@izon.cz>
 */
class ImageConfiguration implements IImageConfiguration{
    
    /**
     *
     * @var Image
     */
    protected $image;
    
    /**
     *
     * @var IImageSize
     */
    protected $imageSize;
    
    /**
     *
     * @var int
     */
    protected $quality;
    
    /**
     *
     * @var string
     */
    protected $type;
    
    /**
     *
     * @var string
     */
    protected $name;
    
    /**
     *
     * @var IImageSize|null
     */
    protected $cropSize;
    
    /**
     *
     * @var IImagePoint|null
     */
    protected $cropPoint;
    
    /**
     * 
     * @return Image
     */
    public function getImage(): Image {
        return $this->image;
    }

    /**
     * 
     * @return IImageSize
     */
    public function getImageSize(): IImageSize {
        return $this->imageSize;
    }

    /**
     * 
     * @return int|null
     */
    public function getWidth(): ?int {
        if(!$this->imageSize instanceof IImageSize) {
            return null;
        }
        return $this->imageSize->getWidth();
    }

    /**
     * 
     * @return int|null
     */
    public function getHeight(): ?int {
        if(!$this->imageSize instanceof IImageSize) {
            return null;
        }
        return $this->imageSize->getHeight();
    }

    /**
     * 
     * @return int
     */
    public function getQuality(): int {
        return $this->quality;
    }

    /**
     * 
     * @return string
     */
    public function getType(): string {
        return $this->type;
    }
    
    /**
     * 
     * @return string
     */
    public function getName(): string {
        return $this->name;
    }

    /**
     * 
     * @return IImageSize|null
     */
    public function getCropSize(): ?IImageSize {
        return $this->cropSize;
    }

    /**
     * 
     * @return IImagePoint|null
     */
    public function getCropPoint(): ?IImagePoint {
        return $this->cropPoint;
    }

    /**
     * 
     * @param Image $image
     * @return $this
     */
    public function setImage(Image $image) {
        $this->image = $image;
        return $this;
    }

    /**
     * 
     * @param IImageSize $imageSize
     * @return $this
     */
    public function setImageSize(IImageSize $imageSize) {
        $this->imageSize = $imageSize;
        return $this;
    }

    /**
     * 
     * @param int $quality
     * @return $this
     */
    public function setQuality(int $quality) {
        $this->quality = $quality;
        return $this;
    }

    /**
     * 
     * @param string $type
     * @return $this
     */
    public function setType(string $type) {
        $this->type = $type;
        return $this;
    }
    /**
     * 
     * @param string $name
     * @return $this
     */
    public function setName(string $name) {
        $this->name = $name;
        return $this;
    }

    /**
     * 
     * @param IImageSize $cropSize
     * @return $this
     */
    public function setCropSize(IImageSize $cropSize) {
        $this->cropSize = $cropSize;
        return $this;
    }

    /**
     * 
     * @param IImagePoint $cropPoint
     * @return $this
     */
    public function setCropPoint(IImagePoint $cropPoint) {
        $this->cropPoint = $cropPoint;
        return $this;
    }

    /**
     * 
     * @return bool
     */
    public function hasCrop(): bool {
        return ($this->cropPoint instanceof IImagePoint && $this->cropSize instanceof IImageSize);
    }


}
