<?php

namespace IZON\Thumber\Test\ImageResizer\Strategies;

use IZON\Thumber\Image\ImageSize;
use IZON\Thumber\ImageResizer\Strategies\CoverImageResizerStrategy;
use PHPUnit\Framework\TestCase;

/**
 * Description of CoverImageResizerStrategy
 *
 * @author lukas
 */
class CoverImageResizerStrategyTest extends TestCase {

    public function testCoverImageSmallerThanContainer() {
        $imageSize = ImageSize::create(100, 50);
        $containerSize = ImageSize::create(200, 150);
        $computedSize = CoverImageResizerStrategy::getSize($imageSize, $containerSize);
        $this->assertEquals($imageSize->getWidth(), $computedSize->getWidth());
        $this->assertEquals($imageSize->getHeight(), $computedSize->getHeight());
    }

    public function testCoverImageWidthSmallerThanContainer() {
        $imageSize = ImageSize::create(150, 200);
        $containerSize = ImageSize::create(200, 100);
        $computedSize = CoverImageResizerStrategy::getSize($imageSize, $containerSize);
        $this->assertEquals($imageSize->getWidth(), $computedSize->getWidth());
        $this->assertEquals($imageSize->getHeight(), $computedSize->getHeight());
    }

    public function testCoverImageHeightSmallerThanContainer() {
        $imageSize = ImageSize::create(250, 75);
        $containerSize = ImageSize::create(200, 100);
        $computedSize = CoverImageResizerStrategy::getSize($imageSize, $containerSize);
        $this->assertEquals($imageSize->getWidth(), $computedSize->getWidth());
        $this->assertEquals($imageSize->getHeight(), $computedSize->getHeight());
    }

    public function testCoverImageGreaterThanContainer() {
        $imageSize = ImageSize::create(400, 600);
        $containerSize = ImageSize::create(200, 100);
        $computedSize = CoverImageResizerStrategy::getSize($imageSize, $containerSize);
        $this->assertEquals(200, $computedSize->getWidth());
        $this->assertEquals(300, $computedSize->getHeight());
    }

}
