<?php

namespace IZON\Thumber\Tests\Image;

use IZON\Thumber\Image\Exceptions\InvalidSizeException;
use IZON\Thumber\Image\ImageSize;
use PHPUnit\Framework\TestCase;

/**
 * Description of ImageSizeTest
 *
 * @author lukas
 */
class ImageSizeTest extends TestCase {

    protected function createImageSize($width, $height) {
        return ImageSize::create($width, $height);
    }

    /**
     * @test
     */
    public function testCreatingZero() {
        $this->expectException(InvalidSizeException::class);
        $size = ImageSize::create(0, 0);
    }

    /**
     * @test
     */
    public function testCreatingZeroHeight() {
        $this->expectException(InvalidSizeException::class);
        $size = ImageSize::create(100, 0);
    }

    /**
     * @test
     */
    public function testCreatingZeroWidth() {
        $this->expectException(InvalidSizeException::class);
        $size = ImageSize::create(0, 500);
    }

    /**
     * @test
     */
    public function testCreatingNegative() {
        $this->expectException(InvalidSizeException::class);
        $size = ImageSize::create(-1, -5);
    }

    /**
     * @test
     */
    public function testCreatingNegativeHeight() {
        $this->expectException(InvalidSizeException::class);
        $size = ImageSize::create(100, -5);
    }

    /**
     * @test
     */
    public function testCreatingNegativeWidth() {
        $this->expectException(InvalidSizeException::class);
        $size = ImageSize::create(-900, 500);
    }

    /**
     * @test
     */
    public function testAspectRatio() {
        $width = 200;
        $height = 100;
        $imageSize = $this->createImageSize($width, $height);
        $this->assertEquals($height / $width, $imageSize->getAspectRatio());
    }

}
