<?php

namespace IZON\Thumber\Test\ImageResizer;

use IZON\Thumber\Exceptions\InvalidResizerStrategyException;
use IZON\Thumber\Exceptions\UnsupportedResizeTypeException;
use IZON\Thumber\ImageResizer\IImageResizerStrategy;
use IZON\Thumber\ImageResizer\ImageResizer;
use IZON\Thumber\ImageResizer\Strategies\ContainImageResizerStrategy;
use IZON\Thumber\ImageResizer\Strategies\CoverImageResizerStrategy;
use PHPUnit\Framework\TestCase;

/**
 * Description of ImageResizerTest
 *
 * @author lukas
 */
class ImageResizerTest extends TestCase {

    protected function createResizer() {
        $resizer = new ImageResizer([
            ImageResizer::CONTAIN => new ContainImageResizerStrategy(),
            ImageResizer::COVER => new CoverImageResizerStrategy()
        ]);
        return $resizer;
    }

    public function testConstructorUnsupportedType() {
        $this->expectException(UnsupportedResizeTypeException::class);
        $resizer = new ImageResizer([ImageResizer::CONTAIN => new ContainImageResizerStrategy(), 'blee' => new CoverImageResizerStrategy()]);
    }

    public function testConstructorInvalidResizerStrategy() {
        $this->expectException(InvalidResizerStrategyException::class);
        $resizer = new ImageResizer([ImageResizer::CONTAIN => 'biiooo']);
    }

    public function testConstructorNullResizer() {
        $this->expectException(InvalidResizerStrategyException::class);
        $resizer = new ImageResizer([ImageResizer::CONTAIN => null]);
    }

    public function testUnsupportedType() {
        $resizer = $this->createResizer();
        $this->expectException(UnsupportedResizeTypeException::class);
        $resizer->resize('beeke');
    }
    
    public function testOkResizer() {
        $resizer = $this->createResizer();
        $strategy = $resizer->resize(ImageResizer::CONTAIN);
        $this->assertInstanceOf(IImageResizerStrategy::class, $strategy);
    }

}
