<?php

namespace IZON\Thumber\Web\Interceptors;

use IZON\MVC\HttpRequest;
use IZON\MVC\Interceptors\Interceptor;
use IZON\MVC\ModelAndView;
use IZON\Thumber\Services\ThumbnailService;
use IZON\Thumber\Thumber;

/**
 * nacita informace o ga
 */
class ThumberInterceptor implements Interceptor {
    /**
     *
     * @var ThumbnailService 
     */
    protected $thumberService;

    public function __construct(ThumbnailService $thumberService) {
        $this->thumberService = $thumberService;
    }

    public function afterCompletion(HttpRequest $request, $exception) {
        
    }

    public function preHandle(HttpRequest $request) {
        if((isset($_SERVER['HTTP_ACCEPT']) === true) && (strstr($_SERVER['HTTP_ACCEPT'], 'image/webp') !== false)) {
            # Do something for WebP users
            $this->thumberService->setFormat('webp');
        }
    }

    public function postHandle(HttpRequest $request, ModelAndView $model) {
        // adds information about gallery
        $model->putParameter(Thumber::AVAILABLE_AS, $this->thumberService->getThumber());
        return $model;
    }

}
