<?php

namespace IZON\Thumber\Web\Controllers;

use IZON\MVC\Controller;
use IZON\MVC\HttpRequest;
use IZON\MVC\ModelAndView;
use IZON\Thumber\Image\ImageUrlBuilder;
use IZON\Thumber\Services\ThumbnailService;

/**
 * Controller which handles lazy creating images in cache.
 */
class ImageLazyController implements Controller {
    
    /**
     *
     * @var ThumbnailService 
     */
    protected $thumberService;

    /**
     * 
     * @param ThumbnailService $thumberService
     */
    public function __construct(ThumbnailService $thumberService) {
        $this->thumberService = $thumberService;
    }
    
    /**
     * Based on parameters in URL creates demanded image in cache and redirects to it.
     * @param HttpRequest $request
     * @return ModelAndView
     */
    public function execute(HttpRequest $request) {
        $imageConfiguration = ImageUrlBuilder::fromArray($request->getParameters());
        $filePath = $this->thumberService->createThumbnailPath($imageConfiguration);
        return ModelAndView::createURLRedirect('/'.$filePath);        
    }
}
