<?php

namespace IZON\Thumber\ImageConverter;

use IZON\IO\Image;
use IZON\Thumber\Image\IImagePoint;
use IZON\Thumber\Image\IImageSize;

/**
 * Converts image into specified format.
 *
 * @author Aleš Kopecký <kopecky@izon.cz>
 */
interface IImageConverter {
    
    const EXTENSION_WEBP = 'webp';

    /**
     * Sets ImageSize object.
     * @param IImageSize $imageSize Image size object containing image size info.
     * @return IImageConverter
     */
    public function setSize(IImageSize $imageSize) : IImageConverter;
    
    /**
     * Sets quality.
     * @param int $quality
     * @return IImageConverter
     */
    public function setQuality(int $quality) : IImageConverter;
    
    /**
     * Sets format.
     * @param string $format Use constants of IImageConverter interface.
     * @return IImageConverter
     */
    public function setFormat(string $format) : IImageConverter;
    
    /**
     * 
     * @param string $filename
     * @return Image
     */
    public function convert(string $filename) : Image;
    /**
     * 
     * @param IImageSize $size
     * @param IImagePoint $point
     * @return IImageConverter
     */
    public function crop(IImageSize $size, IImagePoint $point) : IImageConverter;
        
    
}
