<?php

/*
 * To change this license header, choose License Headers in Project Properties.
 * To change this template file, choose Tools | Templates
 * and open the template in the editor.
 */

namespace IZON\Thumber\Image;

use IZON\Thumber\ImageResizer\IImageResizer;
use IZON\Thumber\Services\ThumbnailService;
use function IZON\File\normalizePath;

/**
 * Description of ImageNameBuilder
 *
 * @author lukas
 */
class ImageNameBuilder implements IImageNameBuilder {
    /**
     *
     * @var string
     */
    protected $name;
    /**
     *
     * @var string
     */
    protected $format;
    /**
     *
     * @var string
     */
    protected $path;
    /**
     *
     * @var IImageSize
     */
    protected $size;
    /**
     *
     * @var int|null
     */
    protected $quality;
    /**
     *
     * @var string
     */
    protected $type;
    /**
     *
     * @var IImagePoint
     */
    protected $cropPoint;
    /**
     *
     * @var IImageSize
     */
    protected $cropSize;

    /**
     * 
     * @param string $name
     * @param string $format
     * @param string $path
     */
    public function __construct(string $name, string $path, string $format) {
        $this->name = $name;
        $this->path = $path;
        $this->format = $format;
    }

    /**
     * 
     * @return string
     */
    public function build(): string {
        $pathParts = explode('/', normalizePath($this->path));
        $filename = implode('_', $pathParts);
        $filename .= '_' . $this->name;
        if(!empty($this->size)) {
            $filename .= '_' . $this->size->getWidth() . 'x' . $this->size->getHeight();
        }
        if(!is_null($this->quality) && $this->quality != ThumbnailService::QUALITY) {
            $filename .= '-q' . $this->quality;
        }
        if($this->type !== IImageResizer::CONTAIN) {
            $filename .= '-'.$this->type;
        }
        if(!empty($this->cropPoint)) {
            $filename .= '-cp_'.$this->cropPoint->getX().'x'.$this->cropPoint->getY();
        }
        if(!empty($this->cropSize)) {
            $filename .= '-cs_'. $this->cropSize->getWidth() . 'x' . $this->cropSize->getHeight();
        }
        $filename .= '.' . $this->format;
        return $filename;
    }

    /**
     * 
     * @param string $format
     * @return IImageNameBuilder
     */
    public function setFormat(string $format): IImageNameBuilder {
        $this->format = $format;
        return $this;
    }

    /**
     * 
     * @param int $quality
     * @return IImageNameBuilder
     */
    public function setQuality(int $quality): IImageNameBuilder {
        $this->quality = $quality;
        return $this;
    }

    /**
     * 
     * @param IImageSize $size
     * @return IImageNameBuilder
     */
    public function setSize(IImageSize $size): IImageNameBuilder {
        $this->size = $size;
        return $this;
    }

    /**
     * 
     * @param string $type
     * @return IImageNameBuilder
     */
    public function setType(string $type): IImageNameBuilder {
        $this->type = $type;
        return $this;
    }
    /**
     * 
     * @param IImagePoint $point
     * @return IImageNameBuilder
     */
    public function setCropPoint(IImagePoint $point): IImageNameBuilder {
        $this->cropPoint = $point;
        return $this;
    }
    
     /**
     * 
     * @param IImageSize $size
     * @return IImageNameBuilder
     */
    public function setCropSize(IImageSize $size): IImageNameBuilder {
        $this->cropSize = $size;
        return $this;
    }

}
