<?php

namespace IZON\Thumber\Services;

use IZON\IO\Image;
use IZON\Thumber\ImageConfiguration\IImageConfiguration;
use IZON\Thumber\Thumber;

/**
 * servis pro vytvareni nahledu
 */
interface ThumbnailService {
    /**
     * Default image quality
     */
    const QUALITY = 90;

    /**
     * factory for thumber
     * @return Thumber
     */
    public function getThumber(): Thumber;

    /**
     * 
     * @param Image $sourceImage
     * @param array $parameters parametry pro resizovani width nebo heigth
     */
    public function getImageURL(Image $sourceImage, array $parameters = []);

    /**
     * 
     * @param string|null $format
     */
    public function setFormat(?string $format);

    /**
     * 
     * @param IImageConfiguration $config
     * @return string path for image in cache
     */
    public function createThumbnailPath(IImageConfiguration $config): string;
}
