<?php

namespace IZON\Thumber\ImageConfiguration;

use IZON\IO\Image;
use IZON\Thumber\Image\IImagePoint;
use IZON\Thumber\Image\IImageSize;

/**
 * IImageConfiguration
 * @author Aleš Kopecký <kopecky@izon.cz>
 */
interface IImageConfiguration {

    /**
     * 
     * @param Image $image
     */
    public function setImage(Image $image);

    /**
     * 
     * @param IImageSize $imageSize
     */
    public function setImageSize(IImageSize $imageSize);

    /**
     * 
     * @param int $quality
     */
    public function setQuality(int $quality);

    /**
     * 
     * @param string $type
     */
    public function setType(string $type);

    /**
     * 
     * @param IImageSize $size
     */
    public function setCropSize(IImageSize $size);

    /**
     * 
     * @param IImagePoint $point
     */
    public function setCropPoint(IImagePoint $point);

    /**
     * 
     * @return Image
     */
    public function getImage(): Image;

    /**
     * 
     * @return IImageSize
     */
    public function getImageSize(): IImageSize;

    /**
     * 
     * @return int
     */
    public function getWidth(): ?int;

    /**
     * 
     * @return int
     */
    public function getHeight(): ?int;

    /**
     * 
     * @return int
     */
    public function getQuality(): int;

    /**
     * 
     * @return string
     */
    public function getType(): string;

    /**
     * 
     * @return IImageSize|null
     */
    public function getCropSize(): ?IImageSize;

    /**
     * 
     * @return IImagePoint|null
     */
    public function getCropPoint(): ?IImagePoint;
    
    /**
     * Checks if CropPoint and CropSize objects are set and correct type.
     * @return boolean
     */
    public function hasCrop(): bool;
}
