<?php

namespace IZON\Thumber\Image;

use IZON\Thumber\ImageConfiguration\IImageConfiguration;

/**
 * IImageUrlBuilder
 * @author Aleš Kopecký <kopecky@izon.cz>
 */
interface IImageUrlBuilder {
    
    /**
     * 
     * @param string $path
     */
    public function setPath(string $path);
    
    /**
     * Composes URL to image lazy generation controller based on given config.
     * @param IImageConfiguration $config
     * @return string
     */
    public function buildUrl(IImageConfiguration $config): string;
    
    /**
     * Creates IImageConfiguration from parameters given in array.
     * @param array $params
     * @return IImageConfiguration
     */
    public static function fromArray(array $params): IImageConfiguration;    
    
}
