<?php

namespace IZON\Thumber\Test\ImageResizer\Strategies;

use IZON\Thumber\Image\ImageSize;
use IZON\Thumber\ImageResizer\Strategies\ContainImageResizerStrategy;
use PHPUnit\Framework\TestCase;

/**
 * Description of ContainImageResizerStrategyTest
 *
 * @author lukas
 */
class ContainImageResizerStrategyTest extends TestCase {

    public function testContainImageSmallerThanContainer() {
        $imageSize = ImageSize::create(100, 50);
        $containerSize = ImageSize::create(200, 150);
        $computedSize = ContainImageResizerStrategy::getSize($imageSize, $containerSize);
        $this->assertEquals($imageSize->getWidth(), $computedSize->getWidth());
        $this->assertEquals($imageSize->getHeight(), $computedSize->getHeight());
    }

    public function testContainImageWidthGreaterThanContainer() {
        $imageSize = ImageSize::create(400, 100);
        $containerSize = ImageSize::create(200, 100);
        $computedSize = ContainImageResizerStrategy::getSize($imageSize, $containerSize);
        $this->assertEquals($containerSize->getWidth(), $computedSize->getWidth());
        $this->assertEquals(50, $computedSize->getHeight());
    }

    public function testContainImageHeightGreaterThanContainer() {
        $imageSize = ImageSize::create(200, 200);
        $containerSize = ImageSize::create(200, 100);
        $computedSize = ContainImageResizerStrategy::getSize($imageSize, $containerSize);
        $this->assertEquals(100, $computedSize->getWidth());
        $this->assertEquals($containerSize->getHeight(), $computedSize->getHeight());
    }

    public function testContainImageGreaterThanContainer() {
        $imageSize = ImageSize::create(400, 150);
        $containerSize = ImageSize::create(200, 100);
        $computedSize = ContainImageResizerStrategy::getSize($imageSize, $containerSize);
        $this->assertEquals(200, $computedSize->getWidth());
        $this->assertEquals(75, $computedSize->getHeight());
    }

}
